<?php
/*  Minimal ActivityPub inbox.
 *  – Accepts only POST
 *  – Validates that body is JSON
 *  – Returns 202 Accepted for every valid activity
 */

header('Content-Type: application/activity+json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$raw = file_get_contents('php://input');
$activity = json_decode($raw, true);

if ($activity === null) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}

/* ── place signature / activity-type handling here ── */

http_response_code(202);
echo json_encode(['status' => 'accepted']);
