<?php
header("Content-Type: application/activity+json; charset=utf-8");

// Dynamically get current domain and requested URI
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$uri = $_SERVER['REQUEST_URI'] ?? '/';

// Extract actor username from URI like /@alcea or /@alcea?page=1
// We only support one actor, so just get the first segment starting with @
preg_match('~^/@([^/?]+)~', $uri, $matches);
$username = $matches[1] ?? 'alcea';  // fallback username

$actorId = "$scheme://$host/@$username";

echo json_encode([
    "@context" => [
        "https://www.w3.org/ns/activitystreams",
        "https://w3id.org/security/v1"
    ],
    "id" => $actorId,
    "type" => "Person",
    "preferredUsername" => $username,
    "inbox" => "$scheme://$host/fedi/inbox.php",
    "outbox" => "$scheme://$host/fedi/outbox.php",
    "publicKey" => [
        "id" => $actorId . "#main-key",
        "owner" => $actorId,
        "publicKeyPem" => file_get_contents(__DIR__ . "/public.pem")
    ]
], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
