<?php
header("Content-Type: application/jrd+json");

$domain = "alceawis.de";

if (!isset($_GET['resource'])) {
    http_response_code(400);
    echo json_encode(["error" => "Missing resource parameter"]);
    exit;
}

$resource = $_GET['resource'];

if (!preg_match('/^acct:([^@]+)@(.+)$/', $resource, $matches)) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid resource format"]);
    exit;
}

$username = $matches[1];
$host = $matches[2];

if ($host !== $domain || $username !== "alcea") {
    http_response_code(404);
    echo json_encode(["error" => "User not found"]);
    exit;
}

echo json_encode([
    "subject" => "acct:$username@$host",
    "aliases" => [
        "https://$domain/actor.php"
    ],
    "links" => [
        [
            "rel" => "self",
            "type" => "application/activity+json",
            "href" => "https://$domain/actor.php"
        ]
    ]
], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
